% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_media.R
\name{atlas_media}
\alias{atlas_media}
\title{Get metadata on images, sounds and videos}
\usage{
atlas_media(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  data_profile = NULL,
  download_dir = NULL,
  refresh_cache = FALSE
)
}
\arguments{
\item{request}{optional \code{data_request} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{data.frame}: generated by a call to
\code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{data.frame}: generated by a call to
\code{\link[=galah_filter]{galah_filter()}}}

\item{geolocate}{\code{string}: generated by a call to
\code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{data_profile}{\code{string}: generated by a call to
\code{\link[=galah_apply_profile]{galah_apply_profile()}}}

\item{download_dir}{\code{string}: path to directory where downloaded media will
be stored. DEPRECATED; use \code{collect_media()} instead.}

\item{refresh_cache}{\code{logical}: if set to \code{TRUE} and
\code{galah_config(caching = TRUE)} then files cached from a previous query will
be replaced by the current query. DEPRECATED; use \code{collect_media()} instead.}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble)
of metadata of the requested media.
}
\description{
In addition to text data describing individual occurrences and their
attributes, ALA stores images, sounds and videos associated with a given
record. \code{atlas_media} displays metadata for any and all of the media types.
}
\details{
\code{\link[=atlas_media]{atlas_media()}} works by first finding all occurrence records
matching the filter which contain media, then downloading the metadata for the
media. To actually download the files themselves, use \code{\link[=collect_media]{collect_media()}}.
It may be beneficial when requesting a large number of records to show a progress
bar by setting \code{verbose = TRUE} in \code{\link[=galah_config]{galah_config()}}.
}
\section{Examples}{


Download Regent Honeyeater multimedia

\if{html}{\out{<div class="sourceCode r">}}\preformatted{media_data <- galah_call() |>
    galah_identify("Regent Honeyeater") |>
    galah_filter(year == 2011) |>
    atlas_media() |>
    collect_media(path = "folder/your-directory")
}\if{html}{\out{</div>}}

Specify a single media type to download

\if{html}{\out{<div class="sourceCode r">}}\preformatted{media_data <- galah_call() |>
     galah_identify("Eolophus Roseicapilla") |>
     galah_filter(multimedia == "Sound") |>
     atlas_media()
}\if{html}{\out{</div>}}

Filter to only records with a particular licence type

\if{html}{\out{<div class="sourceCode r">}}\preformatted{media_data <- galah_call() |>
     galah_identify("Ornithorhynchus anatinus") |>
     galah_filter(year == 2020) |>
     atlas_media() |>
     dplyr::filter(license == "http://creativecommons.org/licenses/by-nc/4.0/")
}\if{html}{\out{</div>}}

You might also want to check how many records have media files before you
download them. Do this with \code{\link[=atlas_counts]{atlas_counts()}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |>
     galah_filter(multimedia == c("Image", "Sound", "Video")) |>
     galah_group_by(multimedia) |>
     atlas_counts()
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=atlas_counts]{atlas_counts()}} to find the number of records with media; but note this
is not necessarily the same as the number of media files, as each record can have
more than one media file associated with it (see examples section for how to do this).
}
