% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_occurrences.R
\name{atlas_occurrences}
\alias{atlas_occurrences}
\title{Collect a set of occurrences}
\usage{
atlas_occurrences(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  data_profile = NULL,
  select = NULL,
  mint_doi = FALSE,
  doi = NULL,
  file = NULL
)
}
\arguments{
\item{request}{optional \code{data_request} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{data.frame}: generated by a call to
\code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{data.frame}: generated by a call to
\code{\link[=galah_filter]{galah_filter()}}}

\item{geolocate}{\code{string}: generated by a call to
\code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{data_profile}{\code{string}: generated by a call to
\code{\link[=galah_apply_profile]{galah_apply_profile()}}}

\item{select}{\code{data.frame}: generated by a call to
\code{\link[=galah_select]{galah_select()}}}

\item{mint_doi}{\code{logical}: by default no DOI will be generated. Set to
\code{TRUE} if you intend to use the data in a publication or similar.}

\item{doi}{\code{string}: (optional) DOI to download. If provided overrides
all other arguments. Only available for the ALA.}

\item{file}{\code{string}: (Optional) file name. If not given, will be set to
\code{data} with date and time added. The file path (directory) is always given by
\code{galah_config()$package$directory}.}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble) of
occurrences, containing columns as specified by \code{\link[=galah_select]{galah_select()}}.
}
\description{
The most common form of data stored by living atlases are observations of
individual life forms, known as 'occurrences'. This function allows the
user to search for occurrence records that match their specific criteria,
and return them as a \code{tibble} for analysis. Optionally,
the user can also request a DOI for a given download to facilitate citation
and re-use of specific data resources.
}
\details{
Note that unless care is taken, some queries can be particularly large.
While most cases this will simply take a long time to process, if the number
of requested records is >50 million, the call will not return any data. Users
can test whether this threshold will be reached by first calling
\code{\link[=atlas_counts]{atlas_counts()}} using the same arguments that they intend to pass to
\code{atlas_occurrences()}. It may also be beneficial when requesting a large
number of records to show a progress bar by setting \code{verbose = TRUE} in
\code{\link[=galah_config]{galah_config()}}, or to use \code{compute()} to run the call before collecting
it later with \code{collect()}.
}
\examples{
\dontrun{
# Download occurrence records for a specific taxon
galah_config(email = "your_email_here")
galah_call() |>
  galah_identify("Reptilia") |>
  atlas_occurrences()

# Download occurrence records in a year range
galah_call() |>
  galah_identify("Litoria") |>
  galah_filter(year >= 2010 & year <= 2020) |>
  atlas_occurrences()
  
# Or identically with alternative syntax
request_data() |>
  identify("Litoria") |>
  filter(year >= 2010 & year <= 2020) |>
  collect()
  
# Download occurrences records in a WKT-specified area
polygon <- "POLYGON((146.24960 -34.05930,
                     146.37045 -34.05930,
                     146.37045 -34.152549,
                     146.24960 -34.15254,
                     146.24960 -34.05930))"
galah_call() |> 
  galah_identify("Reptilia") |>
  galah_filter(year >= 2010, year <= 2020) |>
  galah_geolocate(polygon) |>
  atlas_occurrences()
  
}
}
