\name{boot_coef}
\alias{boot_coef}

\title{
Plotting Bootstrap Coefficients 
}
\description{
The function plots in one or multiple pages the results from a boostrap generated by the function  \code{BayesianBoot()}, \code{NonParamatricBoot} or \code{nonpar_boot().}
}
\usage{
boot_coef(x, terms = NULL, hist.col = "black", 
                hist.fill = "white", dens.fill = "#FF6666", 
                alpha = 0.2, nrow = NULL, ncol = NULL, 
                plots.per.page = 9, one.by.one = FALSE, title, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{a \code{Bayesian.boot} or \code{NonParametric.boot} object}
  \item{terms}{which terms to plot (default NULL means all terms}
  \item{hist.col}{colour of the  border histogram}
  \item{hist.fill}{the colour of the histogram}
  \item{dens.fill}{the colour of the density estimate}
  \item{alpha}{transparity constant}
  \item{nrow}{how namy rows}
  \item{ncol}{how many columns}
  \item{plots.per.page}{
}
  \item{one.by.one}{the maxiimum plots per page}
  \item{title}{the title}
  \item{\dots}{for more argument}
}
\details{
The function plots in one ore multiple pages the results from a boostrap simulation}
\value{
Greates a ggplot object
}
\references{
Rigby, R. A. and  Stasinopoulos D. M. (2005). Generalized additive models for location, scale and shape,(with discussion), 
\emph{Appl. Statist.}, \bold{54}, part 3, pp 507-554.

Rigby, R. A., Stasinopoulos, D. M.,  Heller, G. Z.,  and De Bastiani, F. (2019)
	\emph{Distributions for modeling location, scale, and shape: Using GAMLSS in R}, Chapman and Hall/CRC. An older version can be found in \url{https://www.gamlss.com/}.

Stasinopoulos D. M. Rigby R.A. (2007) Generalized additive models for location scale and shape (GAMLSS) in R.
\emph{Journal of Statistical Software}, Vol. \bold{23}, Issue 7, Dec 2007, \url{https://www.jstatsoft.org/v23/i07/}.

Stasinopoulos D. M., Rigby R.A., Heller G., Voudouris V., and De Bastiani F., (2017)
\emph{Flexible Regression and Smoothing: Using GAMLSS in R},  Chapman and Hall/CRC.  

(see also \url{https://www.gamlss.com/}).
}
\author{Mikis Stasinopoulos }
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link[gamlss]{term.plot}}
}

\examples{
\donttest{
data(aids)
a<-gamlss(y~pb(x)+qrt,data=aids,family=NBI)
registerDoParallel(cores = 2)
B1 <- BayesianBoot(a, B=100)
stopImplicitCluster()
boot_coef(B1)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
\keyword{regression}
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
