% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Container.R
\name{Container}
\alias{Container}
\title{Container Class}
\arguments{
\item{loadFrom}{optional argument to point to the GDX file being 
read into the Container}
}
\description{
The main object class within GAMS Transfer is called 
Container. The Container is the vessel that allows symbols to be 
linked together (through their domain definitions), it enables 
implicit set definitions, it enables structural manipulations of the 
data (matrix generation), and it allows the user to perform different 
read/write operations.
Please visit https://www.gams.com/latest/docs/API_R_GAMSTRANSFER.html 
for detailed documentation of this package.

Create a new container simply by initializing an object.
}
\section{Fields}{

\describe{
\item{\code{data}}{is a named list containing all symbol data}
}}

\examples{
m = Container$new()
i = m$addSet("i")
j = m$addSet("j")
all_symbols = m$listSymbols()
set_description = m$describeSets()
# create a container and read the file trnsport.gdx
m = Container$new(system.file("extdata", "trnsport.gdx", package = "gamstransfer"))
# access symbol named "x" from the container
x = m["x"]
# list all symbols
all_symbols = m$listSymbols()
# list all sets
all_sets = m$listSets()
# check if the container contains symbol named "i"
has_i = m$hasSymbols("i")
# get a summary of the description of all sets in the Container
set_description = m$describeSets()
}
