      SUBROUTINE PDINV(AA,N,IDIM,AOUT,EIGVCT,EIGVAL,DETLOG,ISTAT)
C
C INPUT:
C     AA    -- INPUT MATRIX
C     N     -- ORDER OF AA
C     IDIM  -- DIMENSION OF SQUARE MATRICES AA, AOUT, AND EIGVCT (AS
C              DEFINED IN DIMENSION STATEMENTS OF CALLING ROUTINE)
C
C OUTPUT:
C     AOUT   -- INVERTED MATRIX
C     EIGVCT -- WORKSPACE FOR EIGENVECTORS (IF REQUIRED)
C     EIGVAL -- WORKSPACE FOR EIGENVALUES (IF REQUIRED)
C     DETLOG -- LOG OF DETERMINANT
C     ISTAT  -- STATUS FLAG:  NON-ZERO INDICATES AA WAS FOUND TO BE
C                 NON-POSITIVE DEFINITE, AOUT RETURNED IS INVERSE OF
C                 APPROXIMATED MATRIX (SEE BELOW)
C
C ---------------------------------------------------------------------
C
C THIS ROUTINE FINDS THE INVERSE OF INPUT MATRIX AA, AA BEING POSITIVE
C DEFINITE, APART FROM THE EFFECT OF ROUNDING, CANCELLATION, OR
C TRUNCATION ERRORS.
C
C INVERSION IS ATTEMPTED BY TRYING TO FIND THE CHOLESKY DECOMPOSITION
C                             AA=(L)D(L')
C     WHERE L IS A LOWER TRIANGULAR UNIT MATRIX,  L' ITS TRANSPOSE, AND
C     D IS A DIAGONAL MATRIX WITH POSITIVE ELEMENTS.
C
C IF AA IS SUFFICIENTLY POSITIVE DEFINITE, THIS DECOMPOSITION SUCCEEDS.
C     THEREAFTER, INVERSION OF L IS AN EXPLICIT PROCESS AND THE INVERSE
C     OF AA IS CALCULATED AND STORED IN AOUT.
C IF AA IS NOT SUFFICIENTLY POSITIVE DEFINITE, THIS IS REVEALED BY ONE
C     OF THE DIAGONAL ELEMENTS OF D BEING NEGATIVE, THE FACTORIZATION
C     FAILS AND A CALL TO JACOBI IS MADE TO FIND THE SPECTRAL
C     DECOMPOSITION OF AA.  EIGENVALUES OF AA ARE REPLACED BY
C     MAX(1.E-07,ABS(EIGENVALUE)), AND AN APPROXIMATION TO THE INVERSE
C     OF AA IS OBTAINED FROM THIS ALTERED SPECTRAL DECOMPOSITION.
C
C THE LOGIC OF THIS PROCEDURE IS DUE TO GREENSTADT(1967) AND
C     MURRAY(1972), AND IS PRESENTED IN LALOUEL REPORT ON OPTIMIZATION.
C THIS PROCEDURE WAS IMPLEMENTED BY J.M. LALOUEL AND SHIRLEY YEE.
C
C REVISED  5/82 BY SR -- RETURN STATUS FLAG
C REVISED 11/84 BY SR -- LOG OF DETERMINANT TO PREVENT OVERFLOW
C REVISED  3/85 BY SR -- PORTABLITY AND DOCUMENTATION CHANGES
C
C ---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION   AA(IDIM,IDIM),AOUT(IDIM,IDIM),EIGVCT(IDIM,IDIM)
      DIMENSION   EIGVAL(*)
C
C COPY AA INTO AOUT
C
      DO 120 I=1,N
         DO 110 J=1,I
            AOUT(J,I) = AA(J,I)
110      CONTINUE
120   CONTINUE
C
C INVERT MATRIX IN-PLACE USING CHOLESKY FACTORS
C
      CALL INVERT(AOUT,N,IDIM,DETLOG,ISTAT)
      IF (ISTAT .EQ. 0) GO TO 999
C
C ---------------------------------------------------------------------
C
C AA COULD NOT BE FACTORIZED WITH ALL DIAGONAL ELEMENTS POSITIVE
C
C
C COPY AA INTO AOUT AGAIN
C
      DO 220 I=1,N
         DO 210 J=1,I
            AOUT(J,I) = AA(J,I)
210      CONTINUE
220   CONTINUE
C
C GET EIGENVECTOR MATRIX AND EIGENVALUES
C
      CALL JACOBI(AOUT,N,IDIM,0,EIGVCT,EIGVAL,COND)
C
C IN THIS SECTION, ANY EIGENVALUE LOWER THAN 1.E-07 (FUNCTION OF
C MACHINE PRECISION) IS REPLACED BY 1.E-07. SEE MURRAY(1972)
C FOR DETAILS ON BOUNDS ON THIS APPROXIMATION.
C
CCC   EIGMIN = EIGVAL(1)                ! :: TEMP FOR MIN EIGENVALUE ::
      DO 310 I=1,N
CCC      IF (EIGVAL(I) .LT. EIGMIN) EIGMIN = EIGVAL(I)     ! :: TEMP ::
         IF (EIGVAL(I) .LT. 0.0)    EIGVAL(I) = ABS(EIGVAL(I))
         IF (EIGVAL(I) .LT. 1.E-07) EIGVAL(I) = 1.E-07
310   CONTINUE
C
C GET INVERSE OF APPROXIMATION TO SPECTRAL FORM OF AA
C
      DO 340 I=1,N
         DO 330 J=1,I
            SUM = 0.0
            DO 320 K=1,N
               SUM = SUM + EIGVCT(J,K)*EIGVCT(I,K)/EIGVAL(K)
320         CONTINUE
            AOUT(J,I) = SUM
330      CONTINUE
340   CONTINUE
C
C RETURN LOG OF DETERMINANT USING UPDATED EIGENVALUES
C
      DETLOG = 0.0
      DO 400 I=1,N
         DETLOG = DETLOG + LOG(EIGVAL(I))
400   CONTINUE
C
999   RETURN
      END
