% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.ms.output.R
\name{read.ms.output}
\alias{read.ms.output}
\title{A utility function to read ms output}
\usage{
read.ms.output(
  msout,
  is.file = TRUE,
  xpose = TRUE,
  verbose = TRUE,
  outfile = NULL,
  outfileonly = FALSE
)
}
\arguments{
\item{msout}{an ms output.}

\item{is.file}{a flag indicating ms output as a system file or an R object.}

\item{xpose}{a flag to obtain the tranposed format as it is (when TRUE).}

\item{verbose}{when TRUE, display on screen every 1000 for large nsam.}

\item{outfile}{to save the haplotypes in a tab-delimited ASCII file.}

\item{outfileonly}{to reset gametes to NA when nsam/nreps is very large and is useful with outfile.

The returned value is a list storing the results.
\describe{
\item{call}{system call to ms}
\item{seed}{random number seed to ms}
\item{nsam}{number of copies of the locus in each sample}
\item{nreps}{the number of independent samples to generate}
\item{segsites}{a vector of the numbers of segregating sites}
\item{times}{vectors of time to most recent ancester (TMRCA) and total tree lengths}
\item{positions}{positions of polymorphic sites on a scale of (0,1)}
\item{gametes}{a list of haplotype arrays}
\item{probs}{the probability of the specified number of segregating sites 
given the genealogical history of the sample and the value to -t option}
}}
}
\description{
This function reads in the output of the program ms, a program to generate
samples under a variety of neutral models.
}
\details{
The argument indicates either a file name or a vector of character strings,
one string for each line of the output of ms. As with the second case, it
is appropriate with system(,intern=TRUE), see example below.
}
\examples{
\dontrun{
# Assuming ms is on the path

system("ms 5 4 -s 5 > ms.out")
msout1 <- read.ms.output("ms.out")

system("ms 50 4 -s 5 > ms.out")
msout2 <- read.ms.output("ms.out",outfile="out",outfileonly=TRUE)

msout <- system("ms 5 4 -s 5 -L", intern=TRUE)
msout3 <- read.ms.output(msout,FALSE)
}

}
\references{
Hudson RR (2002) Generating samples under a Wright-Fisher neutral model. Bioinformatics 18:337-8,

Press WH, SA Teukolsky, WT Vetterling, BP Flannery (1992). Numerical Recipes in C. Cambridge University Press, Cambridge.
}
\author{
D Davison, RR Hudson, JH Zhao
}
\keyword{utilities}
