% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_gapclosing_list.R
\name{df_to_gapclosing_list}
\alias{df_to_gapclosing_list}
\title{Convert Back to Canonical List Output}
\usage{
df_to_gapclosing_list(x)
}
\arguments{
\item{x}{A data frame produced by \code{as.data.frame(x)} applied to an object \code{x} of class \code{gapclosing}.}
}
\value{
A list containing a subset of the elements in a \code{gapclosing} object.
}
\description{
If the user has used \code{as.data.frame(x)} to convert a \code{gapclosing} object to a data frame of estimates, this function will invert back to the original list format. This function does not fully reinstate the original gapclosing object because some elements are lost when \code{as.data.frame()} is called. This function is most useful as a check on \code{as.data.frame()} and as a helper in settings like bootstrapping where a data frame is easier to work with but we want to return to the original format before returning an object to the user.
}
\examples{
# Simulate example data
simulated_data <- generate_simulated_data(n = 100)

# Fit by outcome modeling
estimate <- gapclosing(
  data = simulated_data,
  outcome_formula = formula(outcome ~ treatment * category + confounder),
  treatment_name = "treatment",
  category_name = "category",
  counterfactual_assignments = 1
)
summary(estimate)

# Convert to a data frame
estimate.df <- as.data.frame(estimate)
# Convert back to a list
estimate.df <- df_to_gapclosing_list(estimate.df)
}
\references{
Lundberg I (2021). "The gap-closing estimand: A causal approach to study interventions that close disparities across social categories." Sociological Methods and Research. Available at {https://osf.io/gx4y3/}.
}
