% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfill.R
\name{Index}
\alias{Index}
\alias{IndexTwoOne}
\alias{IndexOneFour}
\title{Index Conversions}
\usage{
IndexTwoOne(index, dimTwo)

IndexOneFour(index, dimFour)
}
\arguments{
\item{index}{Integer vector of length 2 for
\code{IndexTwoOne()} and length 1 for \code{IndexOneFour()}.}

\item{dimTwo}{Integer vector of length 2
indicating the dimension of the 2 dimensional array.}

\item{dimFour}{Integer vector of length 4
indicating the dimension of the 4 dimensional array.}
}
\value{
Vector of length 1 for \code{IndexTwoOne()} and
length 4 for \code{IndexOneFour()}.
}
\description{
Converts an index from the first length to the second length.
For example, assume that \code{c(2, 2)} indexes an element in a matrix with 2 rows and 5 columns.
If the matrix is transformed to a vector,
the same element can be accessed with the index \code{IndexTwoOne(c(2, 2), c(2, 5))} (=4).
}
\examples{
## IndexTwoOne
IndexTwoOne(c(2, 2), c(2, 5))
v <- 1:10
dimTwo <- c(2, 5)
m <- array(v, dimTwo)
stopifnot(v[IndexTwoOne(c(2, 2), dimTwo)] == m[2,2])

 
## IndexOneFour
IndexOneFour(13, c(2, 2, 2, 2))
w <- 1:16
dimFour <- c(2, 2, 2, 2)
a <- array(w, dimFour)
stopifnot(a[1,1,2,2] == w[13])

}
\author{
Florian Gerber, \email{flora.fauna.gerber@gmail.com}.
}
