% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_simulate.R
\name{gas_simulate}
\alias{gas_simulate}
\title{Simulate GAS Model}
\usage{
gas_simulate(gas_object = NULL, t_sim = 1L, x_sim = NULL, distr = NULL,
  param = NULL, scaling = "unit", regress = "joint", n = NULL,
  p = 1L, q = 1L, par_static = NULL, par_link = NULL,
  par_init = NULL, coef_est = NULL)
}
\arguments{
\item{gas_object}{An optional GAS estimate, i.e. a list of S3 class \code{gas} returned by function \code{\link[gasmodel:gas]{gas()}}.}

\item{t_sim}{A number of observations to simulate.}

\item{x_sim}{Exogenous variables used for simulations. For a single variable common for all time-varying parameters, a numeric vector. For multiple variables common for all time-varying parameters, a numeric matrix with observations in rows. For individual variables for each time-varying parameter, a list of numeric vectors or matrices in the above form. The number of observation must be equal to \code{t_sim}.}

\item{distr}{A conditional distribution. See \code{\link[gasmodel:distr]{distr()}} for available distributions.}

\item{param}{A parametrization of the conditional distribution. If \code{NULL}, default parametrization is used. See \code{\link[gasmodel:distr]{distr()}} for available parametrizations.}

\item{scaling}{A scaling function for the score. The supported scaling functions are the unit scaling (\code{scaling = "unit"}), the inverse of the Fisher information matrix scaling (\code{scaling = "fisher_inv"}), and the inverse square root of the Fisher information matrix scaling (\code{scaling = "fisher_inv_sqrt"}). The latter two scalings use the Fisher information for the time-varying parameters only. For the full Fisher information matrix for both time-varying and static parameters, there are the \code{"full_fisher_inv"} and \code{"full_fisher_inv_sqrt"} scalings. For the individual Fisher information for each parameter, there are the \code{"diag_fisher_inv"} and \code{"diag_fisher_inv_sqrt"} scalings. Note that when the parametrization is orthogonal (see \code{\link[gasmodel:distr]{distr()}}), there are no differences between these scaling variants.}

\item{regress}{A specification of the regression and dynamic equation with regard to exogenous variables. The supported specifications are exogenous variables and dynamics within the same equation (\code{regress = "joint"}) and separate equations for exogenous variables and dynamics in the fashion of regression models with dynamic errors (\code{regress = "sep"}). In a stationary model without exogenous variables, the two specifications are equivalent, although with differently parametrized intercept.}

\item{n}{A dimension of the model. Required only for multivariate models.}

\item{p}{A score order. For order common for all parameters, a numeric vector of length 1. For individual order for each parameter, a numeric vector of length equal to the number of parameters. Defaults to \code{1L}.}

\item{q}{An autoregressive order. For order common for all parameters, a numeric vector of length 1. For individual order for each parameter, a numeric vector of length equal to the number of parameters. Defaults to \code{1L}.}

\item{par_static}{An optional logical vector indicating static parameters. Overrides \code{x}, \code{p}, and \code{q}.}

\item{par_link}{An optional logical vector indicating whether the logarithmic/logistic link should be applied to restricted parameters in order to obtain unrestricted values. Defaults to applying the logarithmic/logistic link for time-varying parameters and keeping the original link for constant parameters.}

\item{par_init}{An optional numeric vector of initial values of time-varying parameters. For \code{NA} values or when \code{NULL}, set initial values to unconditional values of time-varying parameters. For example, in the case of GAS(1,1) model with \code{regress = "joint"}, to \code{omega / (1 - phi1)}. Not to be confused with starting values for the optimization \code{coef_start}.}

\item{coef_est}{A numeric vector of estimated coefficients.}
}
\value{
A \code{list} of S3 class \code{gas_simulate} with components:
\item{data$x_sim}{The exogenous variables used in simulation.}
\item{model$distr}{The conditional distribution.}
\item{model$param}{The parametrization of the conditional distribution.}
\item{model$scaling}{The scaling function.}
\item{model$regress}{The specification of the regression and dynamic equation.}
\item{model$t_sim}{The length of the simulated time series.}
\item{model$n}{The dimension of the model.}
\item{model$m}{The number of exogenous variables.}
\item{model$p}{The score order.}
\item{model$q}{The autoregressive order.}
\item{model$par_static}{The static parameters.}
\item{model$par_link}{The parameters with the logarithmic/logistic links.}
\item{model$par_init}{The initial values of the time-varying parameters.}
\item{model$coef_est}{The estimated coefficients.}
\item{simulation$y_sim}{The simulated time series.}
\item{simulation$par_tv_sim}{The simulated time-varying parameters.}
\item{simulation$score_tv_sim}{The simulated scores.}
}
\description{
A function for simulation of generalized autoregressive score (GAS) models of Creal et al. (2013) and Harvey (2013).
Instead of supplying arguments about the model, the function can be applied to the \code{gas} object obtained by the \code{\link[gasmodel:gas]{gas()}} function.
}
\note{
Supported generic functions for S3 class \code{gas_simulate} include \code{\link[base:summary]{summary()}} ans \code{\link[base:plot]{plot()}}.
}
\examples{
# Simulate GAS model based on the Weibull distribution with dynamic scale
sim_gas <- gas_simulate(t_sim = 50, distr = "weibull",
  coef_est = c(0.2, 0.1, 0.8, 2.0))
sim_gas

# Plot the simulated time series
plot(sim_gas)

}
\references{
Creal, D., Koopman, S. J., and Lucas, A. (2013). Generalized Autoregressive Score Models with Applications. \emph{Journal of Applied Econometrics}, \strong{28}(5), 777–795. \doi{10.1002/jae.1279}.

Harvey, A. C. (2013). \emph{Dynamic Models for Volatility and Heavy Tails: With Applications to Financial and Economic Time Series}. Cambridge University Press. \doi{10.1017/cbo9781139540933}.
}
\seealso{
\code{\link[gasmodel:gas]{gas()}}
}
