% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frobreg.R
\name{frrg}
\alias{frrg}
\title{Robust regression using Huber's psi-function or Hampel's redescending psi-function without P-values}
\usage{
frrg(y,x,cn=1,cnr=c(1,2,4),sg=0,scale=T,inr=T,xinr=F,red=F)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{cn}{Tuning parameter for Huber's psi-function}

\item{cnr}{Tuning constants for Hampel's three part redescending psi function}

\item{sg}{Scale}

\item{scale}{ Logical, if TRUE calculates sg simultaneously, otherwise keeps initial sg}

\item{inr}{Logical if TRUE to include intercept}

\item{xinr}{Logical if TRUE intercept already included}

\item{red}{Logical If TRUE Hampel's three part redescending psi function}
}
\value{
beta Regression coefficients

res  Residuals

sg  Scale

rho Sums of rho, psi and psi1 functions.
}
\description{
Robust regression using Huber's psi-function or Hampel's redescending psi-function without P-values
}
\examples{
data(boston)
a<-frrg(boston[,14],boston[,1:13])
}
