% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f1st.R
\name{f1st}
\alias{f1st}
\title{Stepwise selection of covariates}
\usage{
f1st(y,x,p0=0.01,kmn=0,kmx=0,kex=0,mx=21,sub=T,inr=T,xinr=F,qq=-1)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{p0}{The P-value cut-off}

\item{kmn}{The minimum number of included covariates irrespective of cut-off P-value}

\item{kmx}{The maximum number of included covariates irrespective of cut-off P-value.}

\item{kex}{The excluded covariates}

\item{mx}{The maximum number covariates for an all subset search}

\item{sub}{Logical if TRUE best subset selected}

\item{inr}{Logical if TRUE include intercept if not present}

\item{xinr}{Logical if TRUE intercept already present}

\item{qq}{The number of covariates to choose from. If qq=-1 the number of covariates of x is used.}

}
\value{
pv In order the included covariates, the regression coefficient values, the Gaussian P-values, the standard P-values.

res The residuals

}
\description{
Stepwise selection of covariates
}
\examples{
data(boston)
bostint<-fgeninter(boston[,1:13],2)[[1]]
a<-f1st(boston[,14],bostint,kmn=10,sub=TRUE)
}
