% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalBindings.R
\name{GDALOpen}
\alias{GDALOpen}
\title{Open GDAL raster}
\usage{
GDALOpen(filename, readonly = TRUE)
}
\arguments{
\item{filename}{Character. The path to a GDAL dataset.}

\item{readonly}{Logical. Flag to open a read only GDALDataset with GA_ReadOnly or GA_Update. Default TRUE.}
}
\value{
An R6 object of GDALDataset class.
}
\description{
Function to open GDAL Dataset
}
\examples{
ds_path <- system.file("extdata", "example.tif", package="gdalBindings")

ds <- GDALOpen(ds_path)
ds$Close()
}
