% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearblack.R
\name{nearblack}
\alias{nearblack}
\title{Interface to GDAL's nearblack utility}
\usage{
nearblack(
  infile,
  o = infile,
  ...,
  of,
  co,
  white,
  color,
  near,
  nb,
  setalpha,
  setmask,
  q,
  dryrun = FALSE
)
}
\arguments{
\item{infile}{Character. Path to a GDAL-supported readable
datasource.}

\item{o}{Optionally, a character string giving the path to a
GDAL-supported output file. If not supplied, defaults to
code{infile=}, indicating that the input file should be
modified in place.}

\item{...}{Here, a placeholder argument that forces users to
supply exact names of all subsequent formal arguments.}

\item{of, co, white, color, near, nb, setalpha, setmask, q}{See the GDAL
project's
\href{https://gdal.org/programs/nearblack.html}{nearblack
documentation} for details.}

\item{dryrun}{Logical (default \code{FALSE}). If \code{TRUE},
instead of executing the requested call to GDAL, the function
will print the command-line call that would produce the
equivalent output.}
}
\value{
Silently returns path to \code{datasetname}.
}
\description{
This function provides an interface mirroring that of the GDAL
command-line app \code{nearblack}. For a description of the
utility and the arguments that it takes, see the documentation at
\url{https://gdal.org/programs/nearblack.html}.
}
\examples{
\donttest{
td <- tempdir()
a_rast <- file.path(td, "a.tif")
b_rast <- file.path(td, "b.tif")
file.copy(system.file("extdata/tahoe.tif", package = "gdalUtilities"),
          a_rast)
file.copy(system.file("extdata/tahoe.tif", package = "gdalUtilities"),
          b_rast)
nearblack(a_rast, b_rast, of = "GTiff")
nearblack(a_rast, of = "GTiff", near = 100)
}
}
\author{
Joshua O'Brien
}
