% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_util.R
\name{autoCreateWarpedVRT}
\alias{autoCreateWarpedVRT}
\title{Create a virtual warped dataset automatically}
\usage{
autoCreateWarpedVRT(
  src_ds,
  dst_wkt,
  resample_alg,
  src_wkt = "",
  max_err = 0,
  alpha_band = FALSE
)
}
\arguments{
\item{src_ds}{An object of class \code{GDALRaster} for the source dataset.}

\item{dst_wkt}{WKT string specifying the coordinate system to convert to.
If empty string (\code{""}) no change of coordinate system will take place.}

\item{resample_alg}{Character string specifying the sampling method to use.
One of NearestNeighbour, Bilinear, Cubic, CubicSpline, Lanczos, Average,
RMS or Mode.}

\item{src_wkt}{WKT string specifying the coordinate system of the source
raster. If empty string it will be read from the source raster (the
default).}

\item{max_err}{Numeric scalar specifying the maximum error measured in
input pixels that is allowed in approximating the transformation (\code{0.0} for
exact calculations, the default).}

\item{alpha_band}{Logical scalar, \code{TRUE} to create an alpha band if the
source dataset has none. Defaults to \code{FALSE}.}
}
\value{
An object of class \code{GDALRaster} for the new virtual dataset. An
error is raised if the operation fails.
}
\description{
\code{autoCreateWarpedVRT()} creates a warped virtual dataset representing the
input raster warped into a target coordinate system. The output virtual
dataset will be "north-up" in the target coordinate system. GDAL
automatically determines the bounds and resolution of the output virtual
raster which should be large enough to include all the input raster.
Wrapper of \code{GDALAutoCreateWarpedVRT()} in the GDAL Warper API.
}
\note{
The returned dataset will have no associated filename for itself. If you
want to write the virtual dataset to a VRT file, use the
\verb{$setFilename()} method on the returned \code{GDALRaster} object to assign a
filename before it is closed.
}
\examples{
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
ds <- new(GDALRaster, elev_file)

ds2 <- autoCreateWarpedVRT(ds, epsg_to_wkt(5070), "Bilinear")
ds2$info()

## set filename before close if a VRT file is needed for the virtual dataset
# ds2$setFilename("/path/to/file.vrt")

ds2$close()
ds$close()
}
