\name{simul.simplefield}
\alias{simul.simplefield}
\concept{Simulation}
\concept{ODF visualization}
\concept{Glyph field mapping}
\title{Simulation of a Simple Field of Diffusion Profiles for von Mises-Fisher Fibre Orientation Mapping}
\description{
The synthesized field of diffusion profiles generated by \code{simul.simplefield} are used to reconstruct ODF profiles using the GQI method.
ODF profiles and fibre directions are estimated using mixtures of von Mises-Fisher (vMF) distributions for directional mapping. 
}

\usage{
simul.simplefield(ang=60, b=3000, sigma=NULL, threshold=0.5)
}

\arguments{
\item{ang}{ angle in degrees of crossing fibres to be used in simulation (default: 60). }
\item{b}{ strength of the magnetic diffusion gradient (default b-value=3000). }
\item{sigma}{ Rician noise level used in simulation; (default \code{NULL}). }
\item{threshold}{ thresholding generalized fractional anisotropy (GFA) value at each voxel (default: 0.5). }
}

\value{
\code{simul.simplefield} plots the reconstructed field of ODF profiles together with the vMF-estimated fiber directions.
}

\details{
The number of fibres is automatically estimated from the diffusion profile.
Noisy profiles may be simulated by adding Rician noise to the simulated diffusion profile, with a user defined standard deviation level specified as \eqn{\sigma} (SNR=1/\eqn{\sigma}). 
}

\references{
Ferreira da Silva, A. R. Facing the Challenge of Estimating Human Brain White Matter Pathways. In \emph{Proc. of the 4th International Joint Conference on Computational Intelligence} (Oct. 2012), K. Madani, J. Kacprzyk, and J. Filipe, Eds., SciTePress, pp. 709-714.

Hornik, K., and Gruen, B. \pkg{movMF}: Mixtures of von Mises-Fisher Distributions, 2012. R package version 0.1-0.

Adler, D., and Murdoch, D. \pkg{rgl}: 3D visualization device system (OpenGL), 2012. R package version 0.92.880.

Barber, C. B., Habel, K., Grasman, R., Gramacy, R. B., Stahel, A., and Sterratt, D. C. \pkg{geometry}: Mesh generation and surface tessellation, 2012. R package version 0.3-2.
} 

\author{ Adelino Ferreira da Silva, Universidade Nova de Lisboa,
  Faculdade de Ciencias e Tecnologia, Portugal, \email{afs at fct.unl.pt}
}

\seealso{
  \code{\link{simulglyph.vmf}},
  \code{\link{simul.fandtasia}},
  \code{\link{synthfiberss2z}},
  \code{\link{plotglyph}},
  \code{\link{gqi.odfvmflines}},
  \code{\link{rgbvolmap}},
  \code{\link{gqi.odfpeaks}},
  \code{\link{gqi.odfpeaklines}},
  \code{\link{gqi.odfvxgrid}}
}

\examples{
\dontrun{
  simul.simplefield(ang=60, b=3000, sigma=NULL)
  ##
  simul.simplefield(ang=60, b=3000, sigma=0.033)
}
}

\keyword{ utilities }

