/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.summary;

import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.drugis.common.beans.AbstractObservable;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.MCMCResultsEvent;
import org.drugis.mtc.MCMCResultsListener;
import org.drugis.mtc.Parameter;
import org.drugis.mtc.summary.Summary;
import org.drugis.mtc.summary.SummaryUtil;

public class NormalSummary
extends AbstractObservable
implements MCMCResultsListener,
Summary {
    public static final String PROPERTY_MEAN = "mean";
    public static final String PROPERTY_STANDARD_DEVIATION = "standardDeviation";
    private final MCMCResults d_results;
    private final Parameter d_parameter;
    private double d_mean = 0.0;
    private double d_stdev = 0.0;
    private boolean d_defined = false;

    public NormalSummary(MCMCResults results, Parameter parameter) {
        this.d_results = results;
        this.d_parameter = parameter;
        this.calculateResults();
        results.addResultsListener(this);
    }

    @Override
    public void resultsEvent(MCMCResultsEvent event) {
        this.calculateResults();
    }

    private boolean isReady() {
        return this.d_results.getNumberOfSamples() >= 4;
    }

    @Override
    public boolean getDefined() {
        return this.d_defined;
    }

    public double getMean() {
        return this.d_mean;
    }

    public double getStandardDeviation() {
        return this.d_stdev;
    }

    private synchronized void calculateResults() {
        if (!this.isReady()) {
            return;
        }
        List<Double> samples = SummaryUtil.getAllChainsLastHalfSamples(this.d_results, this.d_parameter);
        this.d_mean = SummaryUtil.evaluate(new Mean(), samples);
        this.d_stdev = SummaryUtil.evaluate(new StandardDeviation(), samples);
        this.d_defined = true;
        this.firePropertyChange("defined", null, this.d_defined);
        this.firePropertyChange(PROPERTY_MEAN, null, this.d_mean);
        this.firePropertyChange(PROPERTY_STANDARD_DEVIATION, null, this.d_stdev);
    }
}

