/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectionTransformer {
    public static <V, E> UndirectedGraph<V, E> toUndirected(Graph<V, E> graph, Factory<UndirectedGraph<V, E>> graph_factory, Factory<E> edge_factory, boolean create_new) {
        UndirectedGraph<V, E> out = graph_factory.create();
        for (Object v : graph.getVertices()) {
            out.addVertex(v);
        }
        for (Object e : graph.getEdges()) {
            Pair<V> endpoints = graph.getEndpoints(e);
            V v1 = endpoints.getFirst();
            V v2 = endpoints.getSecond();
            Object to_add = graph.getEdgeType(e) == EdgeType.DIRECTED || create_new ? edge_factory.create() : e;
            out.addEdge(to_add, v1, v2, EdgeType.UNDIRECTED);
        }
        return out;
    }

    public static <V, E> Graph<V, E> toDirected(Graph<V, E> graph, Factory<DirectedGraph<V, E>> graph_factory, Factory<E> edge_factory, boolean create_new) {
        DirectedGraph<V, Object> out = graph_factory.create();
        for (Object v : graph.getVertices()) {
            out.addVertex(v);
        }
        for (Object e : graph.getEdges()) {
            Pair<V> endpoints = graph.getEndpoints(e);
            if (graph.getEdgeType(e) == EdgeType.UNDIRECTED) {
                V v1 = endpoints.getFirst();
                V v2 = endpoints.getSecond();
                out.addEdge(edge_factory.create(), v1, v2, EdgeType.DIRECTED);
                out.addEdge(edge_factory.create(), v2, v1, EdgeType.DIRECTED);
                continue;
            }
            V source = graph.getSource(e);
            V dest = graph.getDest(e);
            Object to_add = create_new ? edge_factory.create() : e;
            out.addEdge(to_add, source, dest, EdgeType.DIRECTED);
        }
        return out;
    }
}

