/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.TunablePerturber;
import java.util.Random;

public class ArbitraryPerturber
implements TunablePerturber {
    private int num;
    private double[][] loadings;
    private double[] mss;
    private static Random rand = new Random();

    public ArbitraryPerturber(double[][] loadings, double[] mss) {
        this.num = Math.min(loadings.length, mss.length);
        this.loadings = loadings;
        this.mss = mss;
    }

    public void perturb(double[][] candarray, int whoseTurn) {
        int counter = 0;
        double step = this.mss[whoseTurn] * rand.nextGaussian();
        for (int i = 0; i < candarray.length; ++i) {
            int j = 0;
            while (j < candarray[i].length) {
                double[] dArray = candarray[i];
                int n = j++;
                dArray[n] = dArray[n] + step * this.loadings[whoseTurn][counter++];
            }
        }
    }

    public int numTurns() {
        return this.num;
    }

    public double jacobian() {
        return 1.0;
    }

    public double[] getStepSizes() {
        double[] tem = new double[this.mss.length];
        System.arraycopy(this.mss, 0, tem, 0, this.mss.length);
        return tem;
    }

    public void setStepSize(double s, int i) {
        this.mss[i] = s;
    }

    public void setStepSizes(double[] s) {
        System.arraycopy(s, 0, this.mss, 0, s.length);
    }
}

