/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading.activity;

import java.util.Collections;
import java.util.List;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.activity.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTransition
implements Transition {
    private final List<? extends Task> d_source;
    private final Task d_target;

    public JoinTransition(List<? extends Task> source, Task target) {
        this.d_source = source;
        this.d_target = target;
    }

    @Override
    public List<Task> getSources() {
        return Collections.unmodifiableList(this.d_source);
    }

    @Override
    public List<Task> getTargets() {
        return Collections.singletonList(this.d_target);
    }

    @Override
    public boolean isReady() {
        for (Task task : this.d_source) {
            if (task.isFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Task> transition() {
        if (!this.isReady()) {
            throw new RuntimeException("Not ready for transition.");
        }
        return this.getTargets();
    }
}

