/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import edu.uci.ics.jung.graph.Hypergraph;
import java.util.List;
import org.drugis.mtc.ConsistencyModel;
import org.drugis.mtc.InconsistencyModel;
import org.drugis.mtc.MCMCSettings;
import org.drugis.mtc.MixedTreatmentComparison;
import org.drugis.mtc.ModelFactory;
import org.drugis.mtc.NodeSplitModel;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.BasicParameter;
import org.drugis.mtc.parameterization.ConsistencyParameterization;
import org.drugis.mtc.parameterization.InconsistencyParameterization;
import org.drugis.mtc.parameterization.NetworkModel;
import org.drugis.mtc.parameterization.NodeSplitParameterization;
import org.drugis.mtc.parameterization.Parameterization;
import org.drugis.mtc.yadas.YadasConsistencyModel;
import org.drugis.mtc.yadas.YadasInconsistencyModel;
import org.drugis.mtc.yadas.YadasNodeSplitModel;
import org.drugis.mtc.yadas.YadasSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YadasModelFactory
implements ModelFactory {
    public static final int DEFAULT_TUNING_ITERATIONS = 20000;
    public static final int DEFAULT_SIMULATION_ITERATIONS = 50000;
    public static final int DEFAULT_NUMBER_OF_CHAINS = 4;
    public static final double DEFAULT_VARIANCE_SCALING = 2.5;
    public static final int DEFAULT_THINNING_FACTOR = 10;
    private MCMCSettings d_defaults = new YadasSettings(20000, 50000, 10, 4, 2.5);

    public static MixedTreatmentComparison buildYadasModel(Network network, Parameterization pmtz, MCMCSettings settings) {
        if (pmtz instanceof ConsistencyParameterization) {
            return new YadasConsistencyModel(network, (ConsistencyParameterization)pmtz, settings);
        }
        if (pmtz instanceof InconsistencyParameterization) {
            return new YadasInconsistencyModel(network, (InconsistencyParameterization)pmtz, settings);
        }
        if (pmtz instanceof NodeSplitParameterization) {
            return new YadasNodeSplitModel(network, (NodeSplitParameterization)pmtz, settings);
        }
        throw new IllegalArgumentException("Unknown parameterization type: " + pmtz.getClass().getSimpleName());
    }

    @Override
    public ConsistencyModel getConsistencyModel(Network network) {
        return new YadasConsistencyModel(network, this.d_defaults);
    }

    @Override
    public InconsistencyModel getInconsistencyModel(Network network) {
        return new YadasInconsistencyModel(network, this.d_defaults);
    }

    @Override
    public NodeSplitModel getNodeSplitModel(Network network, BasicParameter split) {
        return new YadasNodeSplitModel(network, split, this.d_defaults);
    }

    @Override
    public List<BasicParameter> getSplittableNodes(Network network) {
        Hypergraph<Treatment, Study> studyGraph = NetworkModel.createStudyGraph(network);
        return NodeSplitParameterization.getSplittableNodes(studyGraph, NetworkModel.createComparisonGraph(studyGraph));
    }

    @Override
    public MCMCSettings getDefaults() {
        return this.d_defaults;
    }

    @Override
    public void setDefaults(MCMCSettings settings) {
        this.d_defaults = settings;
    }
}

