% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_data_processing.R
\name{extractBarcodes}
\alias{extractBarcodes}
\title{Barcode extraction}
\usage{
extractBarcodes(dat, label, results_dir = "./", mismatch = 0,
  indels = FALSE, bc_backbone, full_output = FALSE, cpus = 1,
  strategy = "sequential", wobble_extraction = TRUE,
  dist_measure = "hamming")
}
\arguments{
\item{dat}{a ShortReadQ object.}

\item{label}{a character string.}

\item{results_dir}{a character string which contains the path to the results directory.}

\item{mismatch}{an positive integer value, default is 0, if greater values are provided they indicate the number of allowed mismatches when identifing the barcode constructe.}

\item{indels}{under construction.}

\item{bc_backbone}{a character string or character vector describing the barcode design, variable positions have to be marked with the letter 'N'.}

\item{full_output}{a logical value. If TRUE additional output files will be generated in order to identify errors.}

\item{cpus}{an integer value, indicating the number of available cpus.}

\item{strategy}{since the future package is used for parallelisation a strategy has to be stated, the default is "sequential"  (cpus = 1) and "multiprocess" (cpus > 1). For further information please read future::plan() R-Documentation.}

\item{wobble_extraction}{a logical value. If TRUE, single reads will be stripped of the backbone and only the "wobble" positions will be left.}

\item{dist_measure}{a character value. If "bc_backbone = 'none'", single reads will be clustered based on a distance measure.
Available distance methods are Optimal string aligment ("osa"), Levenshtein ("lv"), Damerau-Levenshtein ("dl"), Hamming ("hamming"), Longest common substring ("lcs"), q-gram ("qgram"), cosine ("cosine"), Jaccard ("jaccard"), Jaro-Winkler ("jw"),
distance based on soundex encoding ("soundex"). For more detailed information see stringdist function of the stringdist-package for more information)}
}
\value{
one or a list of frequency table(s) of barcode sequences.
}
\description{
Extracts barcodes according to the given barcode design from a fastq file.
}
\examples{

\dontrun{

bc_backbone <- "ACTNNCGANNCTTNNCGANNCTTNNGGANNCTANNACTNNCGANNCTTNNCGANNCTTNNGGANNCTANNACTNNCGANN"
source_dir <- system.file("extdata", package = "genBaRcode")
dat <- ShortRead::readFastq(dirPath = source_dir, pattern = "test_data.fastq.gz")

extractBarcodes(dat, label = "test", results_dir = getwd(), mismatch = 0,
indels = FALSE, bc_backbone)

}
}
