% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{createGDF}
\alias{createGDF}
\title{Creating a gdf File}
\usage{
createGDF(
  BC_dat,
  minDist = 1,
  loga = TRUE,
  ori_BCs = NULL,
  col_type = "rainbow",
  m = "hamming"
)
}
\arguments{
\item{BC_dat}{a BCdat object.}

\item{minDist}{an integer value representing the maximal distance value for which the graph will
contain edges.}

\item{loga}{a logical value indicating the use or non-use of logarithmic read count values.}

\item{ori_BCs}{a vector of character strings containing the barcode sequences (without the fixed positions of the barcode construct).}

\item{col_type}{character sting, choosing one of the available color palettes.}

\item{m}{a character string, Method for distance calculation, default value is Hamming distance. Possible values
are "osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex" (see stringdist function
of the stringdist-package for more information).}
}
\description{
createGDF creates a data file usable with the free graph visualisation tool gephi. The nodes
represent barcodes and its respective size reflects the corresponding read counts. Edges between nodes indicate
a distance between two barcodes of maximal \code{minD}.
If \code{ori_BCs} is provided the node color refelects the distance of a particular barcode to one
of the provided barcode sequences.
}
\examples{

\dontrun{

data(BC_dat)
createGDFFile(BC_dat, minDist = 1, loga = TRUE, ori_BCs = NULL, col_type = "rainbow")

}
}
