% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plotClusterGgTree}
\alias{plotClusterGgTree}
\title{Plotting a Cluster ggTree}
\usage{
plotClusterGgTree(BC_dat, tree_est = "NJ", type = "rectangular", m = "hamming")
}
\arguments{
\item{BC_dat}{a BCdat object.}

\item{tree_est}{a character string, indicating the particular cluster algorithm, possible algorithms are "Neighbor-Joining" ("NJ") and "Unweighted Pair Group Method" ("UPGMA").}

\item{type}{a character string, the graph layout style ('rectangular', 'slanted', 'fan', 'circular', 'radial', 'equal_angle' or 'daylight').}

\item{m}{a character string, Method for distance calculation, default value is Hamming distance. Possible values
are "osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex" (see stringdist function
of the stringdist-package for more information).}
}
\value{
a ggtree object.
}
\description{
Generates a tree plot based on a herachical clustering of the complete distance matrix.
}
\examples{
\dontrun{
data(BC_dat)
plotClusterGgTree(BC_dat, tree_est = "UPGMA", type = "circular")
}
}
