% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.R
\name{import_seqs}
\alias{import_seqs}
\title{Import Sequences}
\usage{
import_seqs(filepath, format = "fasta")
}
\arguments{
\item{filepath}{A character vector containing the path to the DNA sequences file.
Reading files in gzip format (which usually have the '.gz' extension) is
supported.
\emph{Note} that only DNA supported here.}

\item{format}{Either "fasta" (the default) or "fastq"}
}
\value{
object of DNAStringSet class
}
\description{
import DNA sequences in FASTA format
}
\examples{

seqPath <- system.file("extdata", "seqs.fa", package = "geneHapR")
geneSeqs <- import_seqs(filepath = seqPath, format = "fasta")

}
