% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hap2plink.R
\name{plink.pedmap2hap}
\alias{plink.pedmap2hap}
\title{plink.pedmap2hap}
\usage{
plink.pedmap2hap(p.link,
                   hapPrefix = "H",
                   hetero_remove = TRUE,
                   na_drop = TRUE)
}
\arguments{
\item{p.link}{list contains p.link information}

\item{hapPrefix}{prefix of haplotype names}

\item{hetero_remove}{whether remove accessions contains hyb-sites}

\item{na_drop}{whether drop accessions contains missing data ("N", NA)}
}
\value{
object of hapSummary class
}
\description{
convert p.link format data into hapResult
}
\examples{
\donttest{
   pedfile <- system.file("extdata",
                          "snp3kvars-CHR8-25947258-25951166-plink.ped",
                          package = "geneHapR")
   mapfile <- system.file("extdata",
                          "snp3kvars-CHR8-25947258-25951166-plink.map",
                          package = "geneHapR")
   p.link <- import_plink.pedmap(pedfile = pedfile, mapfile = mapfile,
                                 sep_map = "\t", sep_ped = "\t")
   p.link <- filter_plink.pedmap(p.link, mode = "POS",
                                 Chr = "chr08", start = 25948004,
                                 end = 25949944)
   hapResult <- plink.pedmap2hap(p.link, hapPrefix = "H",
                                 hetero_remove = TRUE,
                                 na_drop = TRUE)
}
}
