% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genGSEA.R
\name{genGSEA}
\alias{genGSEA}
\title{GSEA for a gene list with decreasing logFC value}
\usage{
genGSEA(
  genelist,
  org,
  category = c("C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "H"),
  subcategory = NULL,
  minGSSize = 10,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  ...
)
}
\arguments{
\item{genelist}{Order ranked genelist in decreasing order, gene can be
entrez, ensembl or symbol.}

\item{org}{Organism name from `msig_org`.}

\item{category}{MSigDB collection abbreviation, one of C1','C2','C3',
'C4','C5','C6','C7','C8','H'.}

\item{subcategory}{MSigDB sub-collection abbreviation, choose from
`msig_category`.}

\item{minGSSize}{Minimal size of each geneSet for analyzing, default is 10.}

\item{maxGSSize}{Maximal size of each geneSet for analyzing, default is 500.}

\item{pvalueCutoff}{Adjusted pvalue cutoff, default is 0.05.}

\item{...}{Other argument to `GSEA` function}
}
\value{
A `data.frame`.
}
\description{
GSEA for a gene list with decreasing logFC value
}
\examples{
\donttest{
data(geneList, package="genekitr")
gse = genGSEA(genelist = geneList,org = 'human', category='H')
}
}
