% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transID.R
\name{transId}
\alias{transId}
\title{Transform gene id among symbol, entrezid,  ensembl and uniprot}
\usage{
transId(id, trans_to, org, unique = TRUE)
}
\arguments{
\item{id}{Gene ids.}

\item{trans_to}{Transform to which type, one of "symbol", "entrezid",
"ensembl" and "uniprot."}

\item{org}{Short latin name from `ensOrg_name_data`.}

\item{unique}{If keep only one unique mapped ID when one-to-many gene occurs, default is FALSE.}
}
\value{
A character of transformed ids.
}
\description{
Transform gene id among symbol, entrezid,  ensembl and uniprot
}
\examples{
\dontrun{
transId(
  id = c("Cyp2c23", "Fhit", "Gal3st2b", "Trp53", "Tp53"),
  trans_to = "ensembl", org = "mouse", unique = TRUE
)
# input id contains fake id and one-to-many match id
transId(
  id = c("MMD2", "HBD", "RNR1", "TEC", "BCC7", "FAKEID", "TP53"),
  trans_to = "entrez", org = "hg", unique = FALSE
)
}

}
