% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genGO.R
\name{genGO}
\alias{genGO}
\title{Gene GO enrichment analysis}
\usage{
genGO(
  id,
  group_list = NULL,
  org,
  ont,
  pAdjustMethod = "BH",
  pvalueCutoff = 0.05,
  qvalueCutoff = 0.1,
  minGSSize = 10,
  maxGSSize = 500,
  universe,
  ...
)
}
\arguments{
\item{id}{A vector of gene id which can be entrezid, ensembl or symbol.}

\item{group_list}{A list of gene id groups, default is NULL.}

\item{org}{Organism name from `biocOrg_name`.}

\item{ont}{One of "bp", "mf", and "cc" subontologies, or "all" for all three.}

\item{pAdjustMethod}{One of "holm", "hochberg", "hommel", "bonferroni", "BH",
"BY", "fdr", "none".}

\item{pvalueCutoff}{Adjusted pvalue cutoff, default is 0.05.}

\item{qvalueCutoff}{Adjusted pvalue cutoff, default is 0.1.}

\item{minGSSize}{Minimal size of each gene set for analyzing, default is 10.}

\item{maxGSSize}{Maximal size of each gene set for analyzing, default is 500.}

\item{universe}{Background genes. If missing, then all gene list in
orgdb will be used as background.}

\item{...}{other argument to `enrichGO` function}
}
\value{
A `data.frame` contains gene ratio and fold enrichment.
}
\description{
Gene GO enrichment analysis
}
\examples{
\dontrun{
data(geneList, package = "genekitr")

# only gene ids
id <- names(geneList)[abs(geneList) > 2]
ego <- genGO(id,
  org = "human", ont = "bp", pvalueCutoff = 0.01,
  qvalueCutoff = 0.01)

# gene id with groups
id <- c(head(names(geneList),50),tail(names(geneList),50))
group <- list(group1  = c(rep('up',50),rep('down',50)),
  group2 = c(rep('A',40),rep('B',60)))

gego <- genGO(id, group_list = group,
  org = "human", ont = "bp", pvalueCutoff = 0.1,
  qvalueCutoff = 1)

}
}
