% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_genlogis.R
\name{genlog_mle}
\alias{genlog_mle}
\title{Optimization for a generalized logistic distribution}
\usage{
genlog_mle(parameters, data, hessian = F, alpha = 0.05)
}
\arguments{
\item{parameters}{Initial values for the parameters to be optimized over in the following order \code{c(a, b, p, mu)},
\code{mu} can be omitted and will be set to 0.}

\item{data}{This is the the data to be utilized for the estimation.}

\item{hessian}{logical value that returns hessian, also returns the parameters estimation's confidence interval.}

\item{alpha}{Type I error given to calculate confidence intervals, used when \code{hessian = T}.}
}
\value{
Return a list of components as \code{constrOptim} \(for more information, check this function\)
 with some extras: \cr
 
\code{par} The best set of parameters found. 
\cr

\code{value} The value of the loglikelihood function corresponding to \code{par}.
\cr

\code{counts} A two-element integer vector giving the number of calls to the likelihood 
function and \code{BFGS} respectively. This excludes those calls needed to 
compute the Hessian, and any calls to likelihood function to compute a 
finite-difference approximation to the gradient.\cr

\code{convergence} An integer code. 0 indicates successful completion, 1 indicates that 
the iteration limit \code{maxit} had been reached. For more errors \code{help(constrOptim)}.
\cr

\code{message} A character string giving any additional information returned by the optimizer,
 or NULL.
 \cr
 
\code{outer.iterations} gives the number of outer iterations (calls to \code{optim}).
 \cr
 
 \code{barrier.value} giving the value of the barrier function at the optimum.
 \cr
  
For \code{hessian = T} add:

\code{hessian} A symmetric matrix giving an estimate of the (negative) Hessian at the solution found. 
Note that this is the Hessian of the unconstrained problem even if the box 
constraints are active.
\cr

\code{bounds} Return the best parameters found and the upper and lower bounds for the estimation.
\cr
}
\description{
Maximum likehood estimation of parameters for a generalized logistic distribution.
}
\details{
Maximum likehood estimation of parameters for the distribution proposed in this package.\cr
This function is an application of \code{constrOptim} as a particular case needed for this 
distribution using the method "\code{BFGS}".  \cr
For more information of the output check \code{help(constrOptim)}.\cr

The used distribution for this package is given by: 
\deqn{f(x) = ((a + b*(1+p)*(abs(x-mu)^p))*exp(-(x-mu)*(a+b*(|x-mu|^p)))) / ((exp(-(x-mu)*(a + b* (|x-mu|^p)))+1)^2)}

\code{help(dgenlog)} for parameters restrictions.\cr
}
\examples{

## Using generic parameter starting values
datas <- rgenlog(10000, 1.5,2,2, 0)
genlog_mle(c(.5,1.6, 1.5, 0),datas)

## Select parameters starting values with genlog_slider
\donttest{
datas <- rgenlog(10000, 1.5,2,2, 0)
genlog_slider(datas, return_var = 'parameters') ## choose parameters
genlog_mle(parameters,datas)
}

}
\references{
Rathie, P. N. and Swamee, P. K. (2006) \emph{On a new invertible generalized logistic distribution
approximation to normal distribution}, Technical Research Report in Statistics, 07/2006,
Dept. of Statistics, Univ. of Brasilia, Brasilia, Brazil.

Byrd, R. H., Lu, P., Nocedal, J. and Zhu, C. (1995) \emph{A limited memory algorithm for bound constrained optimization}. SIAM J. Scientific Computing, \strong{16}, 1190-1208.
}
\keyword{genlogis}
