% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Heterogametic_Genotype_Warnings.R
\name{Heterogametic_Genotype_Warnings}
\alias{Heterogametic_Genotype_Warnings}
\title{Heterogametic warnings}
\usage{
Heterogametic_Genotype_Warnings(seq_data, sex_chromosome, sex_vector,
  heterogametic_sex)
}
\arguments{
\item{seq_data}{is genotyping data read in with read_in_sequenom_data}

\item{sex_chromosome}{character of the sex chromosome coded in sequenom markers produced with make_marker_names.
For example, the sex chromosome in the data provided with genotypeR is chrXL and it has been coded as
chrXL_start_end. The character provided would be "chrXL"}

\item{sex_vector}{a vector of the sex of each individual in seq_data coded the same as that in heterogametic sex.
For example, a vector of "F" and "M".}

\item{heterogametic_sex}{character of heterogametic sex (e.g., "M")}
}
\value{
A data frame of warnings
}
\description{
\code{Heterogametic_Genotype_Warnings} provides QA for
back cross designs by determine those organisms that have
an impossible genotypes based on their sex.
}
\examples{

data(genotypes_data)
seq_data <- genotypes_data
sex_vector <- do.call(rbind, strsplit(seq_data[,"SAMPLE_NAME"], split="_"))[,2]
Heterogametic_Genotype_Warnings(seq_data=seq_data, sex_chromosome="chrXL",
sex_vector=sex_vector, heterogametic_sex="M")

}
