% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_function.R
\name{or.plot}
\alias{or.plot}
\title{Function to Plot Odds Ratio Results}
\usage{
or.plot(data = NULL, x = "MAF", panel.by = "True.Model",
  y_limit = NULL, y_log = F, return_gg = F,
  linear.effect.measure = "ES", select.Alpha = NULL,
  select.power = NULL, select.ES = NULL, select.N = NULL,
  select.MAF = NULL, select.Case.Rate = NULL, select.SD = NULL,
  select.True.Model = NULL, select.Test.Model = NULL)
}
\arguments{
\item{data}{The data frame result from \code{\link{power.calc}}}

\item{x}{The desired variable on the y axis: "MAF", "OR", "Alpha", or "N_total"}

\item{panel.by}{A grouping variable to panel the graphs by: "True.Model", "MAF", "Power", "Alpha", or "N_total"}

\item{y_limit}{An object specifying the minimum and maximum of the y-axis (eg c(0,4)) default is NULL, which allows the limits to be picked automatically}

\item{y_log}{Logical, specifying whether the y axis should be logarithmic. Default is F}

\item{return_gg}{Logical, specifying whether to return the ggplot object instead of printing out the plot}

\item{linear.effect.measure}{Should the graphs indicate ES values, or R2 values? (default ES)}

\item{select.Alpha}{Only produce graphs for the specified Alpha level(s).}

\item{select.power}{Only produce graphs for the specified Power(s).}

\item{select.ES}{Only produce graphs for the specified effect sizes(s).}

\item{select.N}{Only produce graphs for the specified sample size(s).}

\item{select.MAF}{Only produce graphs for the specified minor allele frequency(ies).}

\item{select.Case.Rate}{Only produce graphs for the specified case rate(s).}

\item{select.SD}{Only produce graphs for the specified standard deviation(s).}

\item{select.True.Model}{Only produce graphs for the specified true genetic model(s): "Additive", "Dominant", "Recessive".}

\item{select.Test.Model}{Only produce graphs for the specified testing model(s): "Additive", "Dominant", "Recessive", "2df".}
}
\value{
A series of plots with power on the Y axis.
}
\description{
Plot the power results by MAF, Power, Alpha or N
}
\examples{
or <- odds_ratio_function(N=1000, Case.Rate=0.5, k=NULL,
    MAF=seq(0.3, 0.32, 0.01), power=0.8,Alpha=0.05,
    True.Model=c("Dominant", "Recessive"), Test.Model=c("Dominant", "Recessive"))
or.plot(data=or, x='MAF')

}
