% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Score_init.R
\name{tp_fp}
\alias{tp_fp}
\title{Calculates the true and false positive rates given the estimated and true edges.}
\usage{
tp_fp(edges, true_edges, p)
}
\arguments{
\item{edges}{A vector of indices corresponding to the estimated edges. Should not contain the diagonals.}

\item{true_edges}{A vector of indices corresponding to the true edges.}

\item{p}{A positive integer, the dimension.}
}
\value{
A vector containing the true positive rate and the false positive rate.
}
\description{
Calculates the true and false positive rates given the estimated and true edges.
}
\examples{
n <- 40
p <- 50
mu <- rep(0, p)
tol <- 1e-8
K <- cov_cons(mode="sub", p=p, seed=1, spars=0.2, eig=0.1, subgraphs=10)
true_edges <- which(abs(K) > tol & diag(p) == 0)
dm <- 1 + (1-1/(1+4*exp(1)*max(6*log(p)/n, sqrt(6*log(p)/n))))
set.seed(1)
domain <- make_domain("R+", p=p)
x <- tmvtnorm::rtmvnorm(n, mean = mu, sigma = solve(K),
       lower = rep(0, p), upper = rep(Inf, p), algorithm = "gibbs",
       burn.in.samples = 100, thinning = 10)
est <- estimate(x, setting="gaussian", elts=NULL, domain=domain, centered=TRUE,
         symmetric="symmetric", lambda_length=100, mode="min_pow",
         param1=1, param2=3, diagonal_multiplier=dm,)
# Apply tp_fp to each estimated edges set for each lambda
TP_FP <- t(sapply(est$edgess, function(edges){tp_fp(edges, true_edges, p)}))
old.par <- par(mfrow=c(1,1), mar=c(5,5,5,5))
plot(c(), c(),  ylim=c(0,1), xlim=c(0,1), cex.lab=1, main = "ROC curve",
  xlab="False Positives", ylab="True Positives")
points(TP_FP[,2], TP_FP[,1], type="l")
points(c(0,1), c(0,1), type = "l", lty = 2)
par(old.par)
}
