% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gridaxes.Lambert.R
\name{gridaxes.Lambert}
\alias{gridaxes.Lambert}
\title{Set up axes for a Lambert projected geoplot}
\usage{
gridaxes.Lambert(limx, limy, scale, b0, xyratio, grid, col, reitur, smareitur,
  axratio, axlabels, b1, l1, projection, dlat, dlon, col1 = 1)
}
\arguments{
\item{limx}{Longitude limits}

\item{limy}{Latitude limits}

\item{scale}{Scale to supply to \code{Proj, invProj}}

\item{b0}{Base latitude for the Lambert projection.  Default value is 65
(typical for Iceland)}

\item{xyratio}{Unused argument (?)}

\item{grid}{If grid is TRUE meridians and parallels are plotted, else not.
Default TRUE}

\item{col}{Color of gridlines}

\item{reitur}{Should the grid show statistical rectangles?}

\item{smareitur}{Should the grid show statistical sub--rectangles?}

\item{axratio}{Parameter usually not changed by the user (?)}

\item{axlabels}{If FALSE no numbers are plotted on the axes. Default TRUE}

\item{b1}{Second latitude to define Lambert projection}

\item{l1}{The longitude defining the Lambert projection, default is the
\code{l1} defined in geopar}

\item{projection}{Projection (but is the function meaningful for other than
Lambert?)}

\item{dlat}{Latitude axis increment between labels}

\item{dlon}{Longitude axis increment between labels}

\item{col1}{Color of axes and labels, default 1 (but might be \code{col}}
}
\value{
No value, useful because of its side effect of adding axes to a
Lambert geo--plot.
}
\description{
Set up axes for a Lambert projected geoplot.
}
\note{
May need further elaboration or simplification (referring to the
general geoplot help). Coordinate with the geoaxes and gridaxes helpfiles
(supply as one??).
}
\seealso{
Called by \code{\link{init}}, calls \code{\link{adjust.grd}},
\code{\link{cut_box.1}}, \code{\link{cut_box.2}}, \code{\link{fill.points}},
\code{\link{invProj}}, \code{\link{Proj}}.
}
\keyword{aplot}

