##' Rhizoctonia root rot infections.
##'
##' A dataset containing the number of infected roots and the sample
##' coordinate. The data were collected by Dr Jim Cook at Washington
##' State University. 
##'
##' \itemize{
##' \item Xcoord Longitude of the sampling location.
##' \item Ycoord Latitude of the sampling location.
##' \item Total Total number of roots sampled at that location.
##' \item Infected Number of infected roots found at that location.
##' \item Yield Barley yield at that location. These data were
##' obtained by hand-harvesting a 4-square-meter area in the sampling
##' location. One observation is missing.
##' }
##' @title Rhizoctonia root rot infections
##' @docType data
##' @format A data frame with 100 rows and 5 variables.
##' @source \url{www.biometrics.tibs.org/datasets/010434.txt}
##' @name rhizoctonia
##' @usage data(rhizoctonia)
##' @references Zhang, H. (2002). On estimation and prediction for
##' spatial generalized linear mixed models. \emph{Biometrics}, 58(1),
##' 129-136.
##' @note We acknowledge Hao Zhang for providing these data.
NULL
