% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparebinlinks.R
\name{comparebinlinks}
\alias{comparebinlinks}
\title{Compare two link functions for the binomial distribution}
\usage{
comparebinlinks(d1, d2, a = -8, b = 8, n = 2001, prob1 = NULL,
  plot = TRUE)
}
\arguments{
\item{d1}{Either a positive number or one of "logit" or "probit"
defining the link function. If positive number, this corresponds
to the \code{robit(d1)} link.}

\item{d2}{Same as \code{d1}.}

\item{a}{Beginning of range of points to evaluate (and plot) the
two link functions.}

\item{b}{End of range of points to evaluate (and plot) the two
link functions.}

\item{n}{Number of points for evaluating (and plot) the two link
functions.}

\item{prob1}{Binomial probabilities corresponding to the first
link function.}

\item{plot}{Whether the two link functions should be plotted. If
so, two plots are created: the left plot shows two curves
corresponding to the two link functions (black is the first) and
the right plot shows their difference (first - second).}
}
\value{
A list with the following elements
\itemize{
  \item \code{scale} The optimal scaling \code{c} such that
    \code{max(abs(link(x/c,d1) - link(x,d2)))} is minimised for
    \code{x = seq(a,b,length.out=n)}
  \item \code{maxdiff} The maximum difference between the two links.
  \item \code{prob2} The corresponding probabilities from \code{prob1}
    to the second link.}
}
\description{
Compare two link functions for the binomial distribution.
}
\details{
Finds the closest (after suitable scaling) of the link function
\code{d2} to \code{d1}. If \code{prob1} is provided, then this
corresponds to probabilities under link \code{d1} and the
probabilities are transformed to \code{d2}. Also creates a plot of
the two link functions.
}
\examples{
\dontrun{
comparebinlinks("logit", 7) # The robit(7) approximates logit
comparebinlinks("probit", 1, prob1 = c(.5, .6, .7, .8, .9))
}
}
