% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\name{spc.colnames}
\alias{spc.colnames}
\alias{spc.colnames,Spectra-method}
\alias{spc.colnames<-}
\alias{spc.colnames<-,Spectra-method}
\title{Column names of \code{Spectra} object}
\usage{
spc.colnames(x)

\S4method{spc.colnames}{Spectra}(x)

spc.colnames(x) <- value

\S4method{spc.colnames}{Spectra}(x) <- value
}
\arguments{
\item{x}{A \code{Spectra} object}

\item{value}{character vector containing new column names to be assigned}
}
\value{
spc.colnames() returns the column  names of an object of class \code{Spectra} 
as a character vector. spc.colnames()<- returns a \code{Spectra} object.
}
\description{
Set or retrieve column names of a \code{Spectra} object
}
\examples{
x <- spc.example_spectra()
head(spc.colnames(x))
# or 
spc.colnames(x) <- spc.cname.construct(x)
spc.colnames(x)
}
\seealso{
\code{\link{spc.cname.construct}}
}
