% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R, R/SpcList-Methods.R
\name{spc.invalid.detect}
\alias{spc.invalid.detect}
\alias{spc.invalid.detect,Spectra-method}
\alias{spc.invalid.detect,list-method}
\title{Determinate invalid rows of a \code{Spectra} object}
\usage{
spc.invalid.detect(source1)

\S4method{spc.invalid.detect}{Spectra}(source1)

\S4method{spc.invalid.detect}{list}(source1)
}
\arguments{
\item{source1}{A  \code{Spectra} object}
}
\value{
logical. TRUE for invalid rows
}
\description{
Determine invalid rows (records) of a \code{Spectra} \code{SpcList} object
}
\examples{
sp=spc.example_spectra()
nrow(sp)
invalid=spc.invalid.detect(sp)
show(invalid); length(invalid)

BL = spc.makeSpcList(sp,"CAST")
invalid=spc.invalid.detect(BL)
show(invalid)

}
