% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R
\name{chop}
\alias{chop}
\title{Split polygon into many}
\usage{
chop(x, size = 10, n = 20)
}
\arguments{
\item{x}{Spatial object}

\item{size}{size of each side of each cell, which makes a square cell}

\item{n}{number of cells to make in each dimension, same number used for
each dimension}
}
\description{
Split polygon into many
}
\details{
Works on spatial classes of type \code{SpatialPolygons},
Well-Known Text character strings, and GeoJSON character strings and lists
}
\examples{
library("rgeos")
wkt <- "POLYGON((-180 -20, -140 55, 10 0, -140 -60, -180 -20))"

# SpatialPolygons input
poly <- readWKT(wkt)
plot(poly)
polys <- chop(x = poly)
to_wkt(polys)
to_wkt(polys)[[2]]
plot(polys)
plot(poly, add = TRUE, lwd = 6)

# SpatialPolygonsDataFrame input
class(poly)
polydf <- as(poly, "SpatialPolygonsDataFrame")
class(polydf)
chop(polydf)

# WKT character input
chop(wkt)

# geojson character input
file <- system.file("examples", "sample1.geojson", package = "geoaxe")
x <- readLines(file)
chop(x)

# geojson json input
x <- structure(x, class = "json")
chop(x)
}

