% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_est.R
\name{get_est}
\alias{get_est}
\title{Get causal estimates comparing two scenarios}
\usage{
get_est(
  obs,
  cf1,
  cf2,
  treat,
  sm_out,
  mediation = FALSE,
  obs_med_log_sum_dens = NA,
  cf1_med_log_sum_dens = NA,
  cf2_med_log_sum_dens = NA,
  lag,
  time_after = TRUE,
  entire_window,
  use_dist,
  windows,
  dist_map,
  dist,
  trunc_level = NA,
  save_weights = TRUE
)
}
\arguments{
\item{obs}{observed density}

\item{cf1}{counterfactual density 1}

\item{cf2}{counterfactual density 2}

\item{treat}{column of a hyperframe that summarizes treatment data. In the form of `hyperframe$column`.}

\item{sm_out}{column of a hyperframe that summarizes the smoothed outcome data}

\item{mediation}{whether to perform causal mediation analysis (don't use; still in development). By default, FALSE.}

\item{obs_med_log_sum_dens}{sum of log densities of mediators for the observed (don't use; still in development)}

\item{cf1_med_log_sum_dens}{sum of log densities of mediators for counterfactual 1 (don't use; still in development)}

\item{cf2_med_log_sum_dens}{sum of log densities of mediators for counterfactual 2 (don't use; still in development)}

\item{lag}{integer that specifies lags to calculate causal estimates}

\item{time_after}{whether to include one unit time difference between treatment and outcome. By default = TRUE}

\item{entire_window}{owin object (the entire region of interest)}

\item{use_dist}{whether to use distance-based maps. By default, TRUE}

\item{windows}{a list of owin objects (if `use_dist = FALSE`)}

\item{dist_map}{distance map (an im object, if `use_dist = TRUE`)}

\item{dist}{distances (a numeric vector within the max distance of `dist_map`)}

\item{trunc_level}{the level of truncation for the weights (0-1)}

\item{save_weights}{whether to save weights}
}
\value{
list of the following:
`cf1_ave_surf`: average weighted surface for scenario 1
`cf2_ave_surf`: average weighted surface for scenario 2
`est_cf`: estimated effects of each scenario
`est_causal`: estimated causal contrasts
`var_cf`: variance upper bounds for each scenario
`var_causal`: variance upper bounds for causal contrasts
`windows`: list of owin objects
}
\description{
`get_est()` generates causal estimates comparing two counterfactual scenarios.
}
\details{
The level of truncation indicates the quantile of weights at which weights are truncated.
That is, if `trunc_level = 0.95`, then all weights are truncated at the 95 percentile of the weights.
}
