% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GFCM.R
\name{calcSFGCMBelongMatrix}
\alias{calcSFGCMBelongMatrix}
\title{Calculate the generalized membership matrix (spatial version)}
\usage{
calcSFGCMBelongMatrix(centers, data, wdata, m, alpha, beta)
}
\arguments{
\item{centers}{A matrix or a dataframe representing the centers of the
clusters with p columns and k rows}

\item{data}{A dataframe or matrix representing the observed data with n rows
and p columns}

\item{wdata}{A dataframe or matrix representing the lagged observed data with
nrows and p columns}

\item{m}{A float representing the fuzziness degree}

\item{alpha}{A float representing the weight of the space in the analysis (0
is a typical fuzzy-c-mean algorithm, 1 is balanced between the two
dimensions, 2 is twice the weight for space)}

\item{beta}{A float for the beta parameter (control speed convergence and classification crispness)}
}
\value{
A n * k matrix representing the belonging probabilities of each
  observation to each cluster
}
\description{
Calculate the generalized membership matrix (spatial version) according to a set of
centroids, the observed data, the fuzziness degree a neighbouring matrix,
a spatial weighting term and a beta parameter
}
\examples{
#This is an internal function, no example provided
}
\keyword{internal}
