\name{land use}

\alias{cropland_africa}

\title{Land use data}

\description{
Download land use / land cover data. Currently only QED cropland for Africa, resampled to 30-seconds resolution.
}

\usage{
cropland_africa(path) 
}

\arguments{
  \item{path}{character. Path name where the data should be downloaded to}  
}

\value{
SpatRaster
}


\seealso{
This geospatial asset is a probability map of cropland presence across Sub-Saharan Africa. The AI strategy here used a neural network that was trained on an initial 1-million point Geosurvey (https://geosurvey.qed.ai) conducted in 2015. 

The map was generated by the Africa Soil Information Service (AfSIS) project, and is shared under the Creative Commons Attribution-ShareAlike 4.0 International Public License.
}



\examples{
\donttest{
ph <- cropland_africa(path=tempdir())
}
}
