% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{coordinates_to_geometry}
\alias{coordinates_to_geometry}
\title{Transform coordinates to point geometry}
\usage{
coordinates_to_geometry(table, lon_lat = NULL, crs = NULL)
}
\arguments{
\item{table}{A \code{tibble} object.}

\item{lon_lat}{A vector, name of longitude and latitude attributes.}

\item{crs}{A coordinate reference system: integer with the EPSG code, or
character with proj4string.}
}
\value{
A \code{sf} object.
}
\description{
From the coordinates defined in fields such as latitude and longitude, it
returns a layer of points.
}
\details{
If we start from a geographic layer, it initially transforms it into a table.

The CRS of the new layer is indicated. If a CRS is not indicated, it
considers the layer's CRS by default and, if it is not a layer, it considers
4326 CRS (WGS84).
}
\examples{
library(sf)

us_state_point <-
  coordinates_to_geometry(layer_us_state,
                          lon_lat = c("intptlon", "intptlat"))

}
\seealso{


Other level definition functions: 
\code{\link{add_geometry}()},
\code{\link{check_key}()},
\code{\link{complete_point_geometry}()},
\code{\link{geolevel}()},
\code{\link{get_empty_geometry_instances}()},
\code{\link{get_geometry}()}
}
\concept{level definition functions}
