% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodist-package.r, R/geodist.R
\docType{package}
\name{geodist}
\alias{geodist}
\title{geodist.}
\usage{
geodist(
  x,
  y,
  paired = FALSE,
  sequential = FALSE,
  pad = FALSE,
  measure = "cheap"
)
}
\arguments{
\item{x}{Rectangular object (matrix, \code{data.frame}, \pkg{tibble},
whatever) containing longitude and latitude coordinates.}

\item{y}{Optional second object which, if passed, results in distances
calculated between each object in \code{x} and each in \code{y}.}

\item{paired}{If \code{TRUE}, calculate paired distances between each entry
in \code{x} and \code{y}, returning a single vector.}

\item{sequential}{If \code{TRUE}, calculate (vector of) distances
sequentially along \code{x} (when no \code{y} is passed), otherwise calculate
matrix of pairwise distances between all points.}

\item{pad}{If \code{sequential = TRUE} values are padded with initial
\code{NA} to return \code{n} values for input with \code{n} rows, otherwise
return \code{n - 1} values.}

\item{measure}{One of "haversine" "vincenty", "geodesic", or "cheap"
specifying desired method of geodesic distance calculation; see Notes.}
}
\value{
If only \code{x} passed and \code{sequential = FALSE}, a square
symmetric matrix containing distances between all items in \code{x}; If only
\code{x} passed and \code{sequential = TRUE}, a vector of sequential
distances between rows of \code{x}; otherwise if \code{y} is passed, a matrix
of \code{nrow(x)} rows and \code{nrow(y)} columns. All return values are
distances in metres.
}
\description{
Convert one or two rectangular objects containing lon-lat coordinates into
vector or matrix of geodesic distances in metres.
}
\note{
\code{measure = "cheap"} denotes the mapbox cheap ruler
\url{https://github.com/mapbox/cheap-ruler-cpp}; \code{measure = "geodesic"}
denotes the very accurate geodesic methods given in Karney (2013)
"Algorithms for geodesics" J Geod 87:43-55, and as provided by the 
code{sf::st_dist()} function.
}
\examples{
n <- 50
# Default "cheap" distance measure is only accurate for short distances:
x <- cbind (runif (n, -0.1, 0.1), runif (n, -0.1, 0.1))
y <- cbind (runif (2 * n, -0.1, 0.1), runif (2 * n, -0.1, 0.1))
colnames (x) <- colnames (y) <- c ("x", "y")
d0 <- geodist (x) # A 50-by-50 matrix
d1 <- geodist (x, y) # A 50-by-100 matrix
d2 <- geodist (x, sequential = TRUE) # Vector of length 49
d2 <- geodist (x, sequential = TRUE, pad = TRUE) # Vector of length 50
d0_2 <- geodist (x, measure = "geodesic") # nanometre-accurate version of d0
}
