% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aacf.R
\name{scl}
\alias{scl}
\title{Calculate Correlation Length}
\usage{
scl(x, threshold = c(0.2, 1/exp(1)), plot = FALSE)
}
\arguments{
\item{x}{A raster or matrix.}

\item{threshold}{A numeric vector containing values between 0 and 1. Indicates
the autocorrelation values to which the rates of decline are measured.}

\item{plot}{Logical. Defaults to \code{FALSE}. If \code{TRUE}, the AACF and
lines showing the considered directions of autocorrelation from the origin
will be plotted.}
}
\value{
A list containing the minimum and maximum distances from an
  autocorrelation value of 1 to the specified autocorrelation values < 1.
  Distances are in the units of the x, y coordinates of the raster image. If more
  than one threshold value is specified, the order of this list will be
  \code{[minval(t1), minval(t2), maxval(t1), maxval(t2)]}.
}
\description{
Calculates the smallest and largest distances to specified autocorrelation
values (e.g., 0.2) of the areal autocorrelation function (AACF). All 180
degrees from the origin of the AACF image are considered for the calculation.
}
\examples{
library(raster)

# import raster image
data(normforest)

# crop raster to much smaller area
x <- crop(normforest, extent(-123, -122.99, 43, 43.01))

# calculate aacf img or matrix
aacf_out <- aacf(x)

# estimate the fastest/slowest declines to 0.20 and 0.37 (1/e) autocorrelation
sclvals <- scl(aacf_out)

# calculate Scl20, the minimum distance to an autocorrelation value of 0.2 in the AACF
Scl20 <- sclvals[1]
}
