% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.r
\docType{class}
\name{Profile-class}
\alias{Profile-class}
\title{Profile Class}
\description{
A class to handle a single profile.
}
\section{Slots}{

\describe{
\item{\code{title}}{title of the profile (e.g. Profile 1).}

\item{\code{number}}{index of the profile.}

\item{\code{xyzData}}{object of Xyz Data Class (\code{\link{XyzData-class}}).}

\item{\code{rawData}}{object of Raw Data Class (\code{\link{RawData-class}}).}

\item{\code{measurementType}}{type of measurement (e.g. Dipole Dipole, Wenner, ...).}

\item{\code{gpsCoordinates}}{object of GpsCoordinates Class (\code{\link{GpsCoordinates-class}}).}
}}
\examples{
# p1 <- new("Profile",
#           title = "Profile 1",
#           xyzData = 
#             new("XyzData", 
#           rawData = 
#             new("RawData",
#                 address = "../example/rawdata/p1_DipolDipol_SW-NE.dat"),
#           measurementType = "DipolDipol",
#           gpsCoordinates = 
#             new("GpsCoordinates",
#                 address = "../example/gps/p1.txt"))
#
# p1@title
# p1@xyzData
# p1@rawData
# p1@measurementType
# p1@gpsCoordinates
#
# plot3dXyz(p1)
}
\seealso{
\code{\link{XyzData-class}}, \code{\link{RawData-class}},
\code{\link{GpsCoordinates-class}}, \code{\link{plot3dXyz}}
}

