% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00Classes.r
\docType{class}
\name{Profile-class}
\alias{Profile-class}
\title{Profile Class}
\description{
A class to handle a single profile.
}
\section{Slots}{

\describe{
\item{\code{title}}{title of the profile (e.g. Profile 1).}

\item{\code{number}}{index of the profile.}

\item{\code{processedData}}{object of Processed Data Class (\code{\link{ProcessedData-class}}).}

\item{\code{rawData}}{object of Raw Data Class (\code{\link{RawData-class}}).}

\item{\code{measurementType}}{type of measurement (e.g. Dipole Dipole, Wenner, ...).}

\item{\code{gpsCoordinates}}{object of GpsCoordinates Class (\code{\link{GpsCoordinates-class}}).}
}}

\examples{
p1 <- new('Profile',
           title = 'Profile 1',
           processedData =
             new('ProcessedData', address = system.file('extdata/processed/p1_DipolDipol_SW-NE.xyz',
                                      package='geoelectrics')),
           rawData =
             new('RawData', address = system.file('extdata/raw/p1_DipolDipol_SW-NE.dat',
                                      package='geoelectrics')),
           measurementType = 'DipoleDipole',
           gpsCoordinates =
             new('GpsCoordinates', address = system.file('extdata/gps/p1.txt',
                                             package='geoelectrics')))

p1@title
p1@processedData
p1@rawData
p1@measurementType
p1@gpsCoordinates

plot3d(p1)
}
\seealso{
\code{\link{ProcessedData-class}}, \code{\link{RawData-class}},
\code{\link{GpsCoordinates-class}}, \code{\link{plot3d}}, \code{\link{plot}}
}
