% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00Classes.r
\docType{class}
\name{RawData-class}
\alias{RawData-class}
\title{Raw Data Class}
\description{
A class to handle geoelectrics raw data.
The raw data class parses .dat files provided by the GeoTest software by Dr. Rauen.
If you want to use another format, overwrite the \code{\link{parseRawDataFile}} method.
}
\section{Slots}{

\describe{
\item{\code{address}}{address of the raw data ascii file.}

\item{\code{points}}{data frame that contains raw data resistance values and their positions (distance and depth).}
}}

\examples{
rawData = new('RawData', address = system.file('extdata/raw/p1_DipolDipol_SW-NE.dat',
          package='geoelectrics'))

data(sinkhole)
sinkhole@profiles[[2]]@rawData
sinkhole@profiles[[2]]@rawData@address
sinkhole@profiles[[2]]@rawData@points
}
\seealso{
\code{\link{parseRawDataFile}}, \code{\link{Profile-class}}, \code{\link{ProfileSet-class}}
}
