% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscb_layer_get_layer.R
\name{get_layer_group}
\alias{get_layer_group}
\alias{get_layer_group.uscb_layer}
\title{Get layer group}
\usage{
get_layer_group(ul, layer_group_name)

\method{get_layer_group}{uscb_layer}(ul, layer_group_name)
}
\arguments{
\item{ul}{A \code{uscb_layer} object.}

\item{layer_group_name}{A layer name.}
}
\value{
A \code{uscb_layer} object.
}
\description{
Get a layer group to interpret its variables. Refines the content of the
object.
}
\examples{

folder <- system.file("extdata", package = "geogenr")
folder <- stringr::str_replace_all(paste(folder, "/", ""), " ", "")
ua <- uscb_acs_5ye(folder = folder)
sa <- ua |> get_statistical_areas()
# sa[6]
# [1] "New England City and Town Area Division"
ul <- uscb_layer(uscb_acs_metadata, ua = ua, geodatabase = sa[6], year = 2015)
layers <- ul |> get_layer_names()
# layers[3]
# [1] "X02_RACE"
ul <- ul |> get_layer(layers[3])
lg <- ul |> get_layer_group_names()

# lg[2]
# [1] "003 - DETAILED RACE"
ul <- ul |> get_layer_group(lg[2])

}
\seealso{
Other data selection functions: 
\code{\link{get_layer_group_names}()},
\code{\link{get_layer_names}()},
\code{\link{get_layer}()},
\code{\link{uscb_folder}()},
\code{\link{uscb_layer}()}
}
\concept{data selection functions}
