% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{model_powerlaw}
\alias{model_powerlaw}
\alias{model_neg_exp}
\title{Calculate risk index using inbuilt models.}
\usage{
model_powerlaw(
  beta,
  link_threshold,
  distance_matrix = the$distance_matrix,
  thresholded_crop_values,
  adj_mat = NULL,
  crop_raster,
  crop_cells_above_threshold,
  metrics = the$parameters_config$`CCRI parameters`$NetworkMetrics$InversePowerLaw
)

model_neg_exp(
  gamma_val,
  link_threshold,
  distance_matrix = the$distance_matrix,
  thresholded_crop_values,
  adj_mat = NULL,
  crop_raster,
  crop_cells_above_threshold,
  metrics = the$parameters_config$`CCRI parameters`$NetworkMetrics$InversePowerLaw
)
}
\arguments{
\item{beta}{A list of beta values. \code{DispersalParameterBeta} in \code{parameters.yaml}.}

\item{link_threshold}{A threshold value for link.}

\item{distance_matrix}{distance matrix, generated during \code{\link[=sean]{sean()}}.}

\item{thresholded_crop_values}{crop values above threshold.}

\item{adj_mat}{Adjacency matrix(optional) representing un-directed graph network.
If this is provided, then gamma_val, distance_matrix, link_threshold and thresholded_crop_values are ignored.
These ignored parameters are used to generate adjacency matrix internally.
This is the only way to use custom adjacency matrix.}

\item{crop_raster}{A raster object for cropland harvest.}

\item{crop_cells_above_threshold}{crop cells above threshold. Only contains cells and not the the values.}

\item{metrics}{A list 2 vectors - metrics and weights.}

\item{gamma_val}{A list of beta values. \code{DispersalParameterGamma} in \code{parameters.yaml}.}
}
\value{
risk index
}
\description{
\itemize{
\item \code{\link[=model_powerlaw]{model_powerlaw()}} calculates risk index using power law.
\item \code{\link[=model_neg_exp]{model_neg_exp()}} calculates risk index using negative exponential.
}
}
\details{
Network metrics should be passed as a list of vectors e.g. \code{list(metrics = c("betweeness"), weights = c(100))}.
Default values are fetched from \code{parameters.yaml} and arguments uses the same structure.
}
