% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rasters.R
\name{tiff_torast}
\alias{tiff_torast}
\title{Get raster object from tif file}
\usage{
tiff_torast(path_to_tif)
}
\arguments{
\item{path_to_tif}{TIFF file. This is an encoding of map in raster format.}
}
\value{
SpatRaster.
}
\description{
This is a wrapper of \code{\link[terra:rast]{terra::rast()}} and generates a raster object if provided with a TIF file.
}
\examples{
\donttest{
# Generate raster for usage
fp <- paste(tempfile(), ".tif", sep = "")
ret <- utils::download.file(
"https://geohabnet.s3.us-east-2.amazonaws.com/util-rasters/avocado_HarvestedAreaFraction.tif",
destfile = fp, method = "auto", mode = "wb")
tiff_torast(fp)
}
}
